<?php

/**
 * CTA
 */

$block = BLOCK_INDEX['26'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_custom_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    // variant type
    [
      [
        'key' => "field_acc_var_type_start_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_acc_var_type_end_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    // variant customization
    [
      [
        'key' => "field_acc_var_custom_start_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Start',
          1 => 'Center',
          2 => 'End',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_var_has_border_{$uid}",
        'label' => 'Has Border',
        'name' => 'var_has_border',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'wrapper' => ['width' => '33.333'],
      ],
      [
        'key' => "field_var_has_shadow_{$uid}",
        'label' => 'Has Shadow',
        'name' => 'var_has_shadow',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'wrapper' => ['width' => '33.333'],
      ],
      [
        'key' => "field_var_has_background_{$uid}",
        'label' => 'Background',
        'name' => 'var_background',
        'type' => 'group',
        'sub_fields' => get_background_fields(),
        'wrapper' => ['width' => '33.333'],
      ],
      [
        'key' => "field_acc_var_custom_end_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
