<?php

$uid = 'module_calendar';
$module_slug = MODULES['calendar']['slug'];
$module_title = MODULES['calendar']['title'];

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => "{$module_title} Field Group",
  'fields' => [
    [
      'key' => 'field_date',
      'label' => 'Date',
      'name' => 'date',
      'type' => 'date_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'required' => 1,
      'conditional_logic' => 0,
      'wrapper' => ['width' => '50'],
      'display_format' => 'F j, Y',
      'return_format' => 'Ymd',
      'first_day' => 0,
    ],
    [
      'key' => 'field_time',
      'label' => 'Time',
      'name' => 'time',
      'type' => 'time_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'wrapper' => ['width' => '50'],
      'display_format' => 'g:i a',
      'return_format' => 'H:i:s',
    ],
    [
      'key' => 'field_url',
      'label' => 'Link',
      'name' => 'link',
      'type' => 'url',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'required' => 1,
    ],
    [
      'key' => 'field_description',
      'label' => 'Description',
      'name' => 'description',
      'type' => 'wysiwyg',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'tabs' => 'visual',
      'toolbar' => 'basic',
      'media_upload' => 0,
      'delay' => 0,
    ],
  ],
  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $module_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    3 => 'slug',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
