<?php

$uid = 'module_partner';
$module_slug = MODULES['partner']['slug'];
$module_title = MODULES['partner']['title'];

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => "{$module_title} Fields",
  'fields' => [
    // capabilities
    // category
    // partner level ?
    // regions
    // languages
    [
      'key' => "field_group_partner_details_{$uid}",
      'label' => 'Details',
      'name' => 'details',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'sub_fields' => [
        [
          'key' => "field_details_website_{$uid}",
          'label' => 'Website',
          'name' => 'website',
          'type' => 'url',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        ],
      ],
    ],
  ],
  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $module_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'featured_image',
    3 => 'slug',
    4 => 'permalink',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
