<?php

$uid = 'module_pricing-plan';
$post_slug = 'pricing-plan';

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => 'Pricing Plan',
  'fields' => [
    // plan options
    [
      'key' => 'field_price_model',
      'label' => 'Pricing Model',
      'name' => 'price_model',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'required' => 1,
      'choices' => [
        'subscription' => 'Subscription',
        'standard' => 'Standard',
      ],
      'default_value' =>
        'Which pricing model will you use? Options between Subscription (Monthly / Yearly) or Standard (One time purchase)',
      'wrapper' => ['width' => '50'],
    ],
    [
      'key' => "field_price_currency_{$uid}",
      'label' => 'Pricing Currency',
      'name' => 'price_currency',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'required' => 1,
      'choices' => [
        'cad' => 'Canadian Dollar ($)',
        'usd' => 'US Dollar ($)',
        'aud' => 'Australian Dollar ($)',
        'eur' => 'Euro (€)',
        'gbp' => 'British Pound (£)',
        'jpy' => 'Japanese Yen (¥)',
      ],
      'default_value' => 'cad',
      'wrapper' => ['width' => '50'],
    ],
    [
      'key' => 'field_price_model_discount',
      'label' => 'Yearly Discount',
      'name' => 'price_model_discount',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Include a discount label on the yearly price? (Ex: -25%) Leave blank to opt out.',
      'conditional_logic' => [
        [
          [
            'field' => 'field_price_model',
            'operator' => '==',
            'value' => 'subscription',
          ],
        ],
      ],
    ],

    // columns
    [
      'key' => "field_price_columns_{$uid}",
      'label' => 'Price Columns',
      'name' => 'price_column',
      'type' => 'repeater',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Supports up to 4 pricing items',
      'required' => 1,
      'layout' => 'table',
      'min' => 1,
      'max' => 4,
      'button_label' => 'Add Price Column',
      'sub_fields' => [
        // options group
        [
          'key' => "field_price_column_options_{$uid}",
          'label' => 'Options',
          'name' => 'price_column_options',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'layout' => 'block',
          'sub_fields' => [
            [
              'key' => "field_column_is_featured_{$uid}",
              'label' => 'Column Featured',
              'name' => 'column_is_featured',
              'type' => 'true_false',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'instructions' =>
                'Makes column visually standout and larger than the others, recommended for most popular pricing. Note: Only use this for 1 column.',
              'ui' => 1,
              'parent_repeater' => "field_price_columns_{$uid}",
            ],
          ],
          'wrapper' => ['width' => '20'],
        ],

        // content group
        [
          'key' => "field_price_column_content_{$uid}",
          'label' => 'Content',
          'name' => 'price_column_content',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'layout' => 'block',
          'sub_fields' => [
            // card header

            // card body

            // card footer

            [
              'key' => 'field_column_title',
              'label' => 'Column Title',
              'name' => 'column_title',
              'type' => 'text',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
              'required' => 1,
              'parent_repeater' => "field_price_columns_{$uid}",
              'wpml_cf_preferences' => 2,
            ],
            [
              'key' => 'field_column_subtitle',
              'label' => 'Column Subtitle',
              'name' => 'column_subtitle',
              'type' => 'wysiwyg',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
              'parent_repeater' => "field_price_columns_{$uid}",
              'tabs' => 'visual',
              'toolbar' => 'basic',
              'media_upload' => 0,
              'delay' => 0,
              'wrapper' => ['class' => 'editor-short'],
            ],
            [
              'key' => 'field_column_price_monthly',
              'label' => 'Column Price (Monthly)',
              'name' => 'column_price_monthly',
              'type' => 'number',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'instructions' => 'Value for monthly price',
              'required' => 1,
              'conditional_logic' => [
                [
                  [
                    'field' => 'field_price_model',
                    'operator' => '==',
                    'value' => 'subscription',
                  ],
                ],
              ],
              'wrapper' => ['width' => '50'],
              'parent_repeater' => "field_price_columns_{$uid}",
              'wpml_cf_preferences' => 1,
            ],
            [
              'key' => 'field_column_price_yearly',
              'label' => 'Column Price (Yearly)',
              'name' => 'column_price_yearly',
              'type' => 'number',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'instructions' => 'Value for yearly price',
              'required' => 1,
              'conditional_logic' => [
                [
                  [
                    'field' => 'field_price_model',
                    'operator' => '==',
                    'value' => 'subscription',
                  ],
                ],
              ],
              'wrapper' => ['width' => '50'],
              'parent_repeater' => "field_price_columns_{$uid}",
            ],
            [
              'key' => 'field_column_price_standard',
              'label' => 'Column Price (One Time)',
              'name' => 'column_price_standard',
              'type' => 'number',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'instructions' => 'Value for standard price',
              'required' => 1,
              'conditional_logic' => [
                [
                  [
                    'field' => 'field_price_model',
                    'operator' => '==',
                    'value' => 'standard',
                  ],
                ],
              ],
              'wrapper' => ['width' => '50'],
              'parent_repeater' => "field_price_columns_{$uid}",
            ],
            [
              'key' => 'field_column_price_detail',
              'label' => 'Column Price detail',
              'name' => 'column_price_detail',
              'type' => 'text',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
              'instructions' => 'Optional detail to display after price (Ex: / per session)',
              'conditional_logic' => [
                [
                  [
                    'field' => 'field_price_model',
                    'operator' => '==',
                    'value' => 'standard',
                  ],
                ],
              ],
              'wrapper' => ['width' => '50'],
              'parent_repeater' => "field_price_columns_{$uid}",
            ],
            [
              'key' => 'field_column_button_group',
              'label' => 'Column Button Group',
              'name' => 'column_button_group',
              'type' => 'repeater',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'layout' => 'table',
              'min' => 0,
              'max' => 2,
              'button_label' => 'Add Button',
              'rows_per_page' => 20,
              'sub_fields' => [
                [
                  'key' => 'field_column_button_link',
                  'label' => 'Link',
                  'name' => 'link',
                  'type' => 'link',
                  'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                  'return_format' => 'array',
                  'parent_repeater' => 'field_column_button_group',
                ],
                [
                  'key' => 'field_column_button_variant',
                  'label' => 'Variant',
                  'name' => 'variant',
                  'type' => 'select',
                  'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
                  'choices' => [
                    0 => 'Primary',
                    1 => 'Secondary',
                    2 => 'Ghost',
                    3 => 'White',
                    4 => 'Link',
                  ],
                  'default_value' => 0,
                  'layout' => 'horizontal',
                  'parent_repeater' => 'field_column_button_group',
                ],
              ],
            ],
            [
              'key' => 'field_column_list',
              'label' => 'Column List',
              'name' => 'column_list',
              'type' => 'repeater',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'instructions' => 'List of features/items included for each Pricing Column',
              'layout' => 'block',
              'button_label' => 'Add List Item',
              'rows_per_page' => 20,
              'parent_repeater' => "field_price_columns_{$uid}",
              'sub_fields' => [
                [
                  'key' => 'field_column_list_item',
                  'label' => 'Column List Item',
                  'name' => 'column_list_item',
                  'type' => 'text',
                  'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                  'parent_repeater' => 'field_column_list',
                ],
              ],
            ],
          ],
          'wrapper' => ['width' => '80'],
        ],
      ],
    ],
  ],
  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $post_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'featured_image',
    3 => 'slug',
    4 => 'permalink',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
