<?php

/**
 * ACF schema helpers, to consolidate common instructions, labels, etc.
 */

define('BLOCK_INDEX', [
  '0' => [
    'name' => 'block_0',
    'legacy_name' => 'cube_0',
    'label' => 'PLX 0 — WYSIWYG',
    'block_name' => 'plexible-blocks/plx-00',
  ],
  '1' => [
    'name' => 'block_1',
    'legacy_name' => 'cube_1',
    'label' => 'PLX 1 — Hero',
    'block_name' => 'plexible-blocks/plx-01',
  ],
  '2' => [
    'name' => 'block_2',
    'legacy_name' => 'cube_2',
    'label' => 'PLX 2 — Dynamic [A]',
    'block_name' => 'plexible-blocks/plx-02',
  ],
  '3' => [
    'name' => 'block_3',
    'legacy_name' => 'cube_3',
    'label' => 'PLX 3 — Dynamic [B]',
    'block_name' => 'plexible-blocks/plx-03',
  ],
  '4' => [
    'name' => 'block_4',
    'legacy_name' => 'cube_4',
    'label' => 'PLX 4 — Dynamic [C]',
    'block_name' => 'plexible-blocks/plx-04',
  ],
  '5' => [
    'name' => 'block_5',
    'legacy_name' => 'cube_5',
    'label' => 'PLX 5 — Logo List',
    'block_name' => 'plexible-blocks/plx-05',
  ],
  '6' => [
    'name' => 'block_6',
    'legacy_name' => 'cube_6',
    'label' => 'PLX 6 — Contact Form',
    'block_name' => 'plexible-blocks/plx-06',
  ],
  '7' => [
    'name' => 'block_7',
    'legacy_name' => 'cube_7',
    'label' => 'PLX 7 — Text Grid',
    'block_name' => 'plexible-blocks/plx-07',
  ],
  '8' => [
    'name' => 'block_8',
    'legacy_name' => 'cube_8',
    'label' => 'PLX 8 — Map',
    'block_name' => 'plexible-blocks/plx-08',
  ],
  '9' => [
    'name' => 'block_9',
    'legacy_name' => 'cube_9',
    'label' => 'PLX 9 — Text & Figure',
    'block_name' => 'plexible-blocks/plx-09',
  ],
  '10' => [
    'name' => 'block_10',
    'legacy_name' => 'cube_10',
    'label' => 'PLX 10 — Image Gallery',
    'block_name' => 'plexible-blocks/plx-10',
  ],
  '11' => [
    'name' => 'block_11',
    'legacy_name' => 'cube_11',
    'label' => 'PLX 11 — Marquee',
    'block_name' => 'plexible-blocks/plx-11',
  ],
  '12' => [
    'name' => 'block_12',
    'legacy_name' => 'cube_12',
    'label' => 'PLX 12 — Vertical Carousel (Beta)',
    'block_name' => 'plexible-blocks/plx-12',
  ],
  '13' => [
    'name' => 'block_13',
    'legacy_name' => 'cube_13',
    'label' => 'PLX 13 — Testimonials',
    'block_name' => 'plexible-blocks/plx-13',
  ],
  '14' => [
    'name' => 'block_14',
    'legacy_name' => 'cube_14',
    'label' => 'PLX 14 — Text',
    'block_name' => 'plexible-blocks/plx-14',
  ],
  '15' => [
    'name' => 'block_15',
    'legacy_name' => 'cube_15',
    'label' => 'PLX 15 — Single Figure',
    'block_name' => 'plexible-blocks/plx-15',
  ],
  '16' => [
    'name' => 'block_16',
    'legacy_name' => 'cube_16',
    'label' => 'PLX 16 — Checklist',
    'block_name' => 'plexible-blocks/plx-16',
  ],
  '17' => [
    'name' => 'block_17',
    'legacy_name' => 'cube_17',
    'label' => 'PLX 17 — Cards',
    'block_name' => 'plexible-blocks/plx-17',
  ],
  '18' => [
    'name' => 'block_18',
    'legacy_name' => 'cube_18',
    'label' => 'PLX 18 — Concierge (Alpha)',
    'block_name' => 'plexible-blocks/plx-18',
  ],
  '19' => [
    'name' => 'block_19',
    'legacy_name' => 'cube_19',
    'label' => 'PLX 19 — Pricing Plan (Beta)',
    'block_name' => 'plexible-blocks/plx-19',
  ],
  '20' => [
    'name' => 'block_20',
    'legacy_name' => 'cube_20',
    'label' => 'PLX 20 — FAQ',
    'block_name' => 'plexible-blocks/plx-20',
  ],
  '21' => [
    'name' => 'block_21',
    'legacy_name' => 'cube_21',
    'label' => 'PLX 21 — Steps (Beta)',
    'block_name' => 'plexible-blocks/plx-21',
  ],
  '22' => [
    'name' => 'block_22',
    'legacy_name' => 'cube_22',
    'label' => 'PLX 22 — Calendar (Alpha)',
    'block_name' => 'plexible-blocks/plx-22',
  ],
  '23' => [
    'name' => 'block_23',
    'legacy_name' => 'cube_23',
    'label' => 'PLX 23 — Blog',
    'block_name' => 'plexible-blocks/plx-23',
  ],
  '24' => [
    'name' => 'block_24',
    'legacy_name' => 'cube_24',
    'label' => 'PLX 24 — Cards Parallax (Beta)',
    'block_name' => 'plexible-blocks/plx-24',
  ],
  '25' => [
    'name' => 'block_25',
    'legacy_name' => 'cube_25',
    'label' => 'PLX 25 — Table (Alpha)',
    'block_name' => 'plexible-blocks/plx-25',
  ],
  '26' => [
    'name' => 'block_26',
    'legacy_name' => 'cube_26',
    'label' => 'PLX 26 — CTA (Beta)',
    'block_name' => 'plexible-blocks/plx-26',
  ],
  '27' => [
    'name' => 'block_27',
    'legacy_name' => 'cube_27',
    'label' => 'PLX 27 — Team (Beta)',
    'block_name' => 'plexible-blocks/plx-27',
  ],
  '28' => [
    'name' => 'block_28',
    'label' => 'PLX 28 — Featured Text',
    'block_name' => 'plexible-blocks/plx-28',
  ],
  '29' => [
    'name' => 'block_29',
    'label' => 'PLX 29 — List',
    'block_name' => 'plexible-blocks/plx-29',
  ],
]);

define('DYNAMIC_BLOCKS', [
  'dynamic_1' => [
    'title' => 'Dynamic One',
    'slug' => 'dynamic_1',
  ],
  'dynamic_2' => [
    'title' => 'Dynamic Two',
    'slug' => 'dynamic_2',
  ],
  'dynamic_3' => [
    'title' => 'Dynamic Three',
    'slug' => 'dynamic_3',
  ],
]);

define('MODULES', [
  'blog' => [
    'key' => 'blog',
    'title' => 'Blog',
    'slug' => 'blog',
    'builder' => true,
    'acf_control' => 'enable_blog',
    'layout' => 'layout_block_23',
    'variants' => [
      0 => 'Default',
      1 => 'BLOX',
    ],
    'premium' => false,
    'taxonomies' => [
      [
        'name' => 'Categories',
        'singular_name' => 'Category',
        'slug' => 'blog_categories',
        'hierarchical' => false,
      ],
    ],
  ],
  'press' => [
    'key' => 'press',
    'title' => 'Press',
    'slug' => 'press',
    'builder' => true,
    'acf_control' => 'enable_press',
    'layout' => null,
    'premium' => false,
  ],
  'testimonial' => [
    'key' => 'testimonial',
    'title' => 'Testimonials',
    'slug' => 'testimonials',
    'builder' => false,
    'acf_control' => 'enable_testimonials',
    'layout' => 'layout_block_13',
    'premium' => false,
  ],
  'partner' => [
    'key' => 'partner',
    'title' => 'Partners',
    'slug' => 'partners',
    'builder' => true,
    'acf_control' => 'enable_partner',
    'layout' => null,
    'premium' => true,
    'taxonomies' => [
      [
        'name' => 'Capabilities',
        'singular_name' => 'Capability',
        'slug' => 'partners_capabilities',
        'hierarchical' => false,
      ],
      [
        'name' => 'Regions',
        'singular_name' => 'Region',
        'slug' => 'partners_regions',
        'hierarchical' => false,
      ],
      [
        'name' => 'Languages',
        'singular_name' => 'Language',
        'slug' => 'partners_languages',
        'hierarchical' => false,
      ],
    ],
  ],
  'faq' => [
    'key' => 'faq',
    'title' => 'FAQ',
    'slug' => 'faq',
    'builder' => false,
    'acf_control' => 'enable_faq',
    'layout' => 'layout_block_20',
    'premium' => false,
  ],
  'pricing-plan' => [
    'key' => 'pricing-plan',
    'title' => 'Pricing Plans',
    'slug' => 'pricing-plan',
    'builder' => false,
    'acf_control' => 'enable_pricing-plan',
    'layout' => 'layout_block_19',
    'premium' => false,
  ],
  'concierge' => [
    'key' => 'concierge',
    'title' => 'Concierge',
    'slug' => 'concierge',
    'builder' => false,
    'acf_control' => 'enable_concierge',
    'layout' => 'layout_block_18',
    'premium' => true,
  ],
  'calendar' => [
    'key' => 'calendar',
    'title' => 'Calendar',
    'slug' => 'calendar',
    'builder' => false,
    'acf_control' => 'enable_calendar',
    'layout' => 'layout_block_22',
    'premium' => true,
  ],
  'team' => [
    'key' => 'team',
    'title' => 'Team',
    'slug' => 'team',
    'builder' => true,
    'acf_control' => 'enable_team',
    'layout' => 'layout_block_27',
    'premium' => false,
  ]
]);

define('ACF_CONSTANTS', [
  'CPT_SLUG_MAX_LENGTH' => 20,
  'ACCEPTED_VIDEO_FILETYPES' => 'mp4,mov,webv,avif',
  'ACCEPTED_IMAGE_FILETYPES' => 'jpeg,jpg,png,webp,avif,svg',
  'TRANSLATE_IGNORE' => 0,
  'TRANSLATE_COPY' => 1,
  'TRANSLATE_COPY_ONCE' => 3,
  'TRANSLATE_ALWAYS' => 2,
]);

define('ACF_INSTRUCTIONS', [
  'CPT_WARNING' =>
    'Understand the consequences before changing post terms. Exsisting posts will be deleted and permalink structure will need to be re-saved.',
  'CPT_SLUG' =>
    'Must be in slug format (example-slug-name) lowercase and dashes only. Max length: ' .
    ACF_CONSTANTS['CPT_SLUG_MAX_LENGTH'] .
    ' characters',
  'IMAGE_UPLOAD' => 'Upload an image or select from media library.',
  'REQUIRED_FIELD' => 'This field is required.',
  'LAYOUT_INSTRUCTIONS' => 'Click the + button below to add a new section.',
  'WYSIWYG_INSTRUCTIONS' => 'Basic HTML tags like <strong>bold</strong> and <em>italic</em> are allowed.',
  'ARCHIVE_LINK_INSTRUCTIONS' => 'Optionally include a link to the page where you display <i>ALL</i> posts.',
]);

function get_acf_relationship_instructions($post_slug, $post_title = '') {
  $home_url = home_url();
  return sprintf(
    'Select which <strong>%s</strong> posts to include, leave blank to include <i>ALL</i> posts. They can be added or modified <a href="%s/wp-admin/edit.php?post_type=%s">here</a>.',
    $post_title,
    $home_url,
    $post_slug,
  );
}

function get_acf_relationship_instructions_single($post_type) {
  $home_url = home_url();
  return sprintf(
    'Select which post to include. They can be added or modified <a href="%s/wp-admin/edit.php?post_type=%s">here</a>.',
    $home_url,
    $post_type,
  );
}

function get_image_size_instructions($width, $height) {
  return sprintf('Recommended image size is %dx%d pixels.', $width, $height);
}
