<?php

$settings = get_theme_options_config();

acf_add_options_page([
  'page_title' => 'Branding',
  'menu_slug' => "{$settings['slug']}-branding",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'edit_posts', // editor access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);

acf_add_local_field_group([
  'key' => 'group_theme-options_branding',
  'title' => "{$settings['title']} > Branding",
  'fields' => [
    [
      // 'key' => 'field_6749cf9832093',
      'key' => 'field_brand_name',
      'label' => 'Brand Name',
      'name' => 'brand_name',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    ],
    [
      'key' => 'field_brand_logo',
      'label' => 'Brand Logo',
      'name' => 'brand_logo',
      'type' => 'image',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'The main logo used sitewide.',
      'wrapper' => ['width' => '50'],
      'return_format' => 'url',
      'library' => 'all',
      'preview_size' => 'medium',
    ],
    [
      'key' => 'field_brand_logo_alt',
      'label' => 'Brand Logo Alt',
      'name' => 'brand_logo_alt',
      'type' => 'image',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Optional alternative logo that will be used on either transparent or dark backgrounds.',
      'wrapper' => ['width' => '50'],
      'return_format' => 'url',
      'library' => 'all',
      'preview_size' => 'medium',
    ],
    [
      'key' => 'field_brand_favicon',
      'label' => 'Brand Favicon',
      'name' => 'brand_favicon',
      'type' => 'image',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' =>
        'Small Icon that appears in the browsers tab. Must be `.png` or `.jpg`. Image size of 512×512 is recommended.',
      'return_format' => 'url',
      'library' => 'all',
      'mime_types' => 'jpg,jpeg,png,webp,svg',
      'preview_size' => 'thumbnail',
    ],
  ],
  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-branding",
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'description' => '',
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'translation',
]);
