<?php

$settings = get_theme_options_config();
$uid = 'options_contact';

acf_add_options_page([
  'page_title' => 'Contact',
  'menu_slug' => "{$settings['slug']}-contact",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'edit_posts', // editor access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);

acf_add_local_field_group([
  'key' => 'group_theme-options_contact',
  'title' => "{$settings['title']} > Contact",
  'fields' => [
    [
      'key' => 'field_674a0ba48f7d8',
      'label' => 'Email',
      'type' => 'tab',
    ],
    [
      'key' => 'field_67652725c5a69',
      'label' => 'Email Label',
      'name' => 'contact_email_label',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'default_value' => 'Email:',
    ],
    [
      'key' => 'field_674a0b537483f',
      'label' => 'Email Address',
      'name' => 'contact_email',
      'type' => 'email',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    ],
    [
      'key' => 'field_674a146a82b0f',
      'label' => 'Phone Number',
      'type' => 'tab',
    ],
    [
      'key' => 'field_6765273bc5a6a',
      'label' => 'Phone Label',
      'name' => 'contact_phone_label',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'default_value' => 'Tel:',
    ],
    [
      'key' => 'field_674a0c0b8f7d9',
      'label' => 'Phone Number',
      'name' => 'contact_phone',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'In this format 000-000-0000. Dashes and Numbers only or formatting will appear broken.',
    ],
    [
      'key' => 'field_674a148282b10',
      'label' => 'Location',
      'type' => 'tab',
    ],
    [
      'key' => 'field_67652758c5a6b',
      'label' => 'Location Label',
      'name' => 'contact_address_label',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'default_value' => 'Location:',
    ],
    [
      'key' => 'field_674a0c338f7da',
      'label' => 'Address',
      'name' => 'contact_address',
      'type' => 'wysiwyg',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'tabs' => 'text',
      'media_upload' => 0,
      'toolbar' => 'full',
    ],
    [
      'key' => 'field_674a14e2aa7e7',
      'label' => 'Social Media',
      'type' => 'tab',
    ],
    [
      'key' => "field_socials_label_{$uid}",
      'label' => 'Social Label',
      'name' => 'contact_social_label',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'default_value' => '',
    ],
    [
      'key' => 'field_674a14eeaa7e8',
      'label' => 'Social Media Accounts',
      'name' => 'social_media_accounts',
      'type' => 'repeater',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'row',
      'pagination' => 0,
      'min' => 0,
      'max' => 6,
      'button_label' => 'Add Social Media',
      'rows_per_page' => 20,
      'sub_fields' => [
        [
          'key' => "field_socials_icon_{$uid}",
          'label' => 'Icon',
          'name' => 'icon_new',
          'type' => 'icon_picker',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'tabs' => [
            0 => 'dashicons',
            1 => 'media_library',
            2 => 'plexible-icons_outline',
            3 => 'plexible-icons_fill',
          ],
          'return_format' => 'array',
          'library' => 'all',
          'parent_repeater' => 'field_674a14eeaa7e8',
        ],
        [
          'key' => 'field_674a15abedb22',
          'label' => 'Icon',
          'name' => 'icon',
          'type' => 'image',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'required' => 0,
          'conditional_logic' => 0,
          'return_format' => 'array',
          'library' => 'all',
          'allow_in_bindings' => 0,
          'preview_size' => 'medium',
          'parent_repeater' => 'field_674a14eeaa7e8',
        ],
        [
          'key' => 'field_674a153daa7ea',
          'label' => 'Link',
          'name' => 'link',
          'type' => 'link',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'return_format' => 'array',
          'parent_repeater' => 'field_674a14eeaa7e8',
        ],
      ],
    ],
  ],
  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-contact",
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'translation',
]);
