<?php

$settings = get_theme_options_config();
$slug_max_length = 20;
$slug_warning = 'Must be in slug format (example-slug-name) lowercase and dashes only.';

acf_add_options_page([
  'page_title' => 'Custom Post Types',
  'menu_slug' => "{$settings['slug']}-cpt",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'create_users', // admin access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);

acf_add_local_field_group([
  'key' => 'group_theme-options_cpt',
  'title' => "{$settings['title']} > Custom Post Types",
  'fields' => [
    [
      'key' => 'field_67520fe395efb',
      'label' => 'Notice:',
      'type' => 'message',
      'message' =>
        'Changing the slug of any of these `Custom Post Types` will delete all posts currently assigned to the post type. Once changed you must re-save the permalink structure. (Settings > Permalinks > Save changes)',
      'new_lines' => 'wpautop',
      'esc_html' => 0,
    ],
    // CPT 1
    [
      'key' => 'field_677d3d6b00c32',
      'label' => 'Custom Post Type 1',
      'type' => 'tab',
    ],
    [
      'key' => 'field_674881be4aae2',
      'label' => 'Custom Post Type 1 Title',
      'name' => 'custom_post_type_1_title',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    ],
    [
      'key' => 'field_674881924aae1',
      'label' => 'Custom Post Type 1 Slug',
      'name' => 'custom_post_type_1_slug',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => $slug_warning,
      'maxlength' => $slug_max_length,
      'allow_in_bindings' => 0,
    ],
    [
      'key' => 'field_674884f64c594',
      'label' => 'Custom Post Type 1 Icon',
      'name' => 'custom_post_type_1_icon',
      'type' => 'icon_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => '',
      'tabs' => [
        0 => 'dashicons',
      ],
      'return_format' => 'string',
    ],
    // CPT 2
    [
      'key' => 'field_677d3d8300c33',
      'label' => 'Custom Post Type 2',
      'type' => 'tab',
    ],
    [
      'key' => 'field_67489a4488bab',
      'label' => 'Custom Post Type 2 Title',
      'name' => 'custom_post_type_2_title',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    ],
    [
      'key' => 'field_67489a4c88bac',
      'label' => 'Custom Post Type 2 Slug',
      'name' => 'custom_post_type_2_slug',
      'aria-label' => '',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => $slug_warning,
      'maxlength' => $slug_max_length,
    ],
    [
      'key' => 'field_67489a5288bad',
      'label' => 'Custom Post Type 2 Icon',
      'name' => 'custom_post_type_2_icon',
      'aria-label' => '',
      'type' => 'icon_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'tabs' => [
        0 => 'dashicons',
      ],
      'return_format' => 'string',
      'allow_in_bindings' => 0,
      'library' => 'all',
      'default_value' => [
        'type' => null,
        'value' => null,
      ],
    ],
    // CPT 3
    [
      'key' => 'field_677d3d8c00c34',
      'label' => 'Custom Post Type 3',
      'type' => 'tab',
    ],
    [
      'key' => 'field_6748c96069ba6',
      'label' => 'Custom Post Type 3 Title',
      'name' => 'custom_post_type_3_title',
      'aria-label' => '',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    ],
    [
      'key' => 'field_6748c96769ba7',
      'label' => 'Custom Post Type 3 Slug',
      'name' => 'custom_post_type_3_slug',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => $slug_warning,
      'maxlength' => $slug_max_length,
    ],
    [
      'key' => 'field_6748c97269ba8',
      'label' => 'Custom Post Type 3 Icon',
      'name' => 'custom_post_type_3_icon',
      'type' => 'icon_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'tabs' => [
        0 => 'dashicons',
      ],
      'return_format' => 'string',
      'allow_in_bindings' => 0,
      'library' => 'all',
      'default_value' => [
        'type' => null,
        'value' => null,
      ],
    ],
  ],
  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-cpt",
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'description' => '',
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'translation',
]);
