<?php

$settings = get_theme_options_config();
$uid = 'partial_footer';

/**
 * Option page
 */
acf_add_options_page([
  'page_title' => 'Footer',
  'menu_slug' => "{$settings['slug']}-footer",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'edit_posts', // editor access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);

/**
 * Field groups
 */
$column_choices = [
  'footer_group_1' => 'Footer Group 1',
  'footer_group_2' => 'Footer Group 2',
  'footer_group_3' => 'Footer Group 3',
  'footer_group_4' => 'Footer Group 4',
  'contact' => 'Contact',
];

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, [
    'label' => 'Column One',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  [
    'key' => "field_enable_col_1_{$uid}",
    'label' => 'Enable Column 1',
    'name' => 'has_column_1',
    'type' => 'true_false',
    'default_value' => 1,
    'ui' => 1,
  ],
  [
    'key' => "field_col_1_title_{$uid}",
    'label' => 'Title',
    'name' => 'column_1_title',
    'type' => 'text',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'required' => 1,
    'wrapper' => ['class' => 'label-x'],
  ],
  [
    'key' => "field_col_1_{$uid}",
    'label' => 'Content',
    'name' => 'column_1',
    'type' => 'select',
    'required' => 1,
    'conditional_logic' => [
      [
        [
          'field' => "field_enable_col_1_{$uid}",
          'operator' => '==',
          'value' => '1',
        ],
      ],
    ],
    'choices' => $column_choices,
    'default_value' => array_key_first($column_choices),
    'return_format' => 'value',
    'multiple' => 0,
    'allow_null' => 0,
    'wrapper' => ['class' => 'label-x'],
  ],
  acf_accordion($uid, ['label' => 'Column One', 'endpoint' => true]),

  acf_accordion($uid, [
    'label' => 'Column Two',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  [
    'key' => "field_enable_col_2_{$uid}",
    'label' => 'Enable Column 2',
    'name' => 'has_column_2',
    'type' => 'true_false',
    'required' => 0,
    'conditional_logic' => 0,
    'message' => '',
    'default_value' => 1,
    'ui' => 1,
  ],
  [
    'key' => "field_col_2_{$uid}",
    'label' => 'Content',
    'name' => 'column_2',
    'type' => 'select',
    'required' => 1,
    'conditional_logic' => [
      [
        [
          'field' => "field_enable_col_2_{$uid}",
          'operator' => '==',
          'value' => '1',
        ],
      ],
    ],
    'choices' => $column_choices,
    'default_value' => array_key_first($column_choices),
    'return_format' => 'value',
    'allow_null' => 0,
  ],
  acf_accordion($uid, ['label' => 'Column Two', 'endpoint' => true]),

  acf_accordion($uid, [
    'label' => 'Column Three',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  [
    'key' => 'field_677d45ab9d940',
    'label' => 'Enable Column 3',
    'name' => 'has_column_3',
    'type' => 'true_false',
    'default_value' => 1,
    'ui' => 1,
  ],
  [
    'key' => 'field_677d4e36c4aaa',
    'label' => 'Content',
    'name' => 'column_3',
    'type' => 'select',
    'required' => 1,
    'conditional_logic' => [
      [
        [
          'field' => 'field_677d45ab9d940',
          'operator' => '==',
          'value' => '1',
        ],
      ],
    ],
    'choices' => $column_choices,
    'default_value' => 'footer_group_1',
    'return_format' => 'value',
    'multiple' => 0,
    'allow_null' => 0,
  ],
  acf_accordion($uid, ['label' => 'Column Three', 'endpoint' => true]),

  acf_accordion($uid, [
    'label' => 'Column Four',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  [
    'key' => 'field_677d45b29d941',
    'label' => 'Enable Column 4',
    'name' => 'has_column_4',
    'type' => 'true_false',
    'required' => 0,
    'conditional_logic' => 0,
    'default_value' => 1,
    'ui' => 1,
  ],
  [
    'key' => 'field_677d4e3dc4aab',
    'label' => 'Content',
    'name' => 'column_4',
    'type' => 'select',
    'required' => 1,
    'conditional_logic' => [
      [
        [
          'field' => 'field_677d45b29d941',
          'operator' => '==',
          'value' => '1',
        ],
      ],
    ],
    'choices' => $column_choices,
    'default_value' => 'footer_group_1',
    'return_format' => 'value',
    'multiple' => 0,
    'allow_null' => 0,
  ],
  acf_accordion($uid, ['label' => 'Column Four', 'endpoint' => true]),
];
$colophon = [
  acf_tab($uid, ['label' => 'Colophon']),

  [
    'key' => 'field_theme-options_footer_colophon',
    'name' => 'colophon',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'layout' => 'block',
    'sub_fields' => [
      [
        'key' => 'field_theme-options_footer_colophon_links',
        'label' => 'Colophon Links',
        'name' => 'links',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'layout' => 'table',
        'pagination' => 0,
        'min' => 0,
        'max' => 6,
        'button_label' => 'Add Link',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => 'field_theme-options_footer_colophon_links_link',
            'label' => 'Link',
            'name' => 'link',
            'type' => 'link',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'return_format' => 'array',
            'parent_repeater' => 'field_theme-options_footer_colophon_links',
          ],
        ],
      ],
      [
        'key' => 'field_theme-options_footer_credits_group',
        'name' => 'credits',
        'type' => 'group',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'layout' => 'block',
        'sub_fields' => [
          [
            'key' => 'field_theme-options_footer_credits_enable',
            'label' => 'Enable Credits',
            'name' => 'enable',
            'type' => 'true_false',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'default_value' => 1,
            'ui' => 1,
            'instructions' => 'Enable `Website by Plexible` credits.',
            'wrapper' => ['width' => '20'],
          ],
          [
            'key' => 'field_theme-options_footer_credits_partner',
            'label' => 'Partner',
            'name' => 'partner',
            'type' => 'group',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'sub_fields' => [
              [
                'key' => 'field_theme-options_footer_credits_partner_name',
                'label' => 'Partner Name',
                'name' => 'name',
                'type' => 'text',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              ],
              [
                'key' => 'field_theme-options_footer_credits_partner_logo',
                'label' => 'Partner Logo',
                'name' => 'logo',
                'type' => 'image',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
                'return_format' => 'url',
                'library' => 'all',
                'preview_size' => 'medium',
              ],
              [
                'key' => 'field_theme-options_footer_credits_partner_link',
                'label' => 'Partner Link',
                'name' => 'link',
                'type' => 'link',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
                'return_format' => 'url',
              ],
            ],
            'conditional_logic' => [
              [
                [
                  'field' => 'field_theme-options_footer_credits_enable',
                  'operator' => '==',
                  'value' => 1,
                ],
              ],
            ],
            'instructions' => 'Enable `Plexible × Partner`.',
            'wrapper' => ['width' => '80'],
          ],
        ],
      ],
    ],
  ],
];
$variants = [
  [
    'key' => "field_var_type_{$uid}",
    'label' => 'Variant',
    'name' => 'footer_variant',
    'type' => 'select',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'choices' => [
      0 => 'Default',
      1 => 'Option 2',
    ],
    'default_value' => 0,
  ],

];
$appearance = [

  [
    'key' => 'field_6785629935683',
    'label' => 'Section Border',
    'name' => 'footer_opt_section_border',
    'aria-label' => '',
    'type' => 'true_false',
    'instructions' => '',
    'required' => 0,
    'conditional_logic' => 0,
    'wrapper' => [
      'width' => '',
      'class' => '',
      'id' => '',
    ],
    'wpml_cf_preferences' => 0,
    'message' => '',
    'default_value' => 0,
    'allow_in_bindings' => 0,
    'ui_on_text' => '',
    'ui_off_text' => '',
    'ui' => 1,
  ],
  [
    'key' => 'field_67853d30d9cd7',
    'label' => 'Background Colour',
    'name' => 'footer_opt_background_color',
    'aria-label' => '',
    'type' => 'color_picker',
    'instructions' => '',
    'required' => 0,
    'conditional_logic' => 0,
    'wrapper' => [
      'width' => '',
      'class' => '',
      'id' => '',
    ],
    'wpml_cf_preferences' => 0,
    'default_value' => '',
    'enable_opacity' => 0,
    'return_format' => 'string',
    'allow_in_bindings' => 0,
  ],
  [
    'key' => 'field_67853d65d9cd8',
    'label' => 'Border Colour',
    'name' => 'footer_opt_border_color',
    'aria-label' => '',
    'type' => 'color_picker',
    'instructions' => '',
    'required' => 0,
    'conditional_logic' => 0,
    'wrapper' => [
      'width' => '',
      'class' => '',
      'id' => '',
    ],
    'wpml_cf_preferences' => 0,
    'default_value' => '',
    'enable_opacity' => 0,
    'return_format' => 'string',
    'allow_in_bindings' => 0,
  ],
  [
    'key' => 'field_6785470978ac1',
    'label' => 'Text Colour',
    'name' => 'footer_opt_text_color',
    'aria-label' => '',
    'type' => 'color_picker',
    'instructions' => '',
    'required' => 0,
    'conditional_logic' => 0,
    'wrapper' => [
      'width' => '',
      'class' => '',
      'id' => '',
    ],
    'wpml_cf_preferences' => 0,
    'default_value' => '',
    'enable_opacity' => 0,
    'return_format' => 'string',
    'allow_in_bindings' => 0,
  ],
  [
    'key' => 'field_6785478f3e9fc',
    'label' => 'Text Muted Colour',
    'name' => 'footer_opt_text_muted_color',
    'aria-label' => '',
    'type' => 'color_picker',
    'instructions' => '',
    'required' => 0,
    'conditional_logic' => 0,
    'wrapper' => [
      'width' => '',
      'class' => '',
      'id' => '',
    ],
    'wpml_cf_preferences' => 0,
    'default_value' => '',
    'enable_opacity' => 0,
    'return_format' => 'string',
    'allow_in_bindings' => 0,
  ],

  acf_accordion($uid, ['label' => 'Options', 'endpoint' => true]),
];

acf_add_local_field_group([
  'key' => 'group_theme-options_footer',
  'title' => "{$settings['title']} > Footer",
  'fields' => [

    // TAB: Variants
    acf_tab($uid, ['label' => 'Content']),

    ...$content,

    // TAB: Colophon
    acf_tab($uid, ['label' => 'Colophon']),

    ...$colophon,

    // TAB: Variants
    acf_tab($uid, ['label' => 'Variants']),

    // TAB: Options
    ...$variants,

    acf_tab($uid, ['label' => 'Options']),

    ...get_option_fields($uid, $appearance, 'footer'),
  ],
  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-footer",
      ],
    ],
  ],

  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'translation',
]);
