<?php

$settings = get_theme_options_config();

$dynamic_one_appearance = [
  [
    'key' => 'field_dynamic_one_var_type',
    'label' => 'Variant',
    'name' => 'var_type',
    'type' => 'select',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'choices' => [
      0 => 'Default',
      1 => 'Variant One',
    ],
    'default_value' => 0,
  ],
];

acf_add_options_page([
  'page_title' => 'Settings',
  'menu_slug' => "{$settings['slug']}-settings",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'create_users', // admin access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);

acf_add_local_field_group([
  'key' => 'group_theme-options_settings',
  'title' => "{$settings['title']} > Settings",
  'fields' => [
    [
      'key' => 'field_schema_version',
      'label' => 'Schema Version',
      'name' => 'schema_version',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'choices' => [
        1 => '1.0',
        2 => '2.0',
        3 => '3.0',
      ],
      'default_value' => 2,
    ],

    // DYNAMIC BLOCKS
    [
      'key' => 'field_dynamic_blocks',
      'label' => 'Dynamic Blocks',
      'name' => 'dynamic_blocks',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Dynamic blocks. These are loosely structured with no indended use cases.',
      'layout' => 'block',
      'sub_fields' => [
        build_dynamic_block_schema(
          DYNAMIC_BLOCKS['dynamic_1']['slug'],
          DYNAMIC_BLOCKS['dynamic_1']['title'],
          $dynamic_one_appearance
        ),
        build_dynamic_block_schema(DYNAMIC_BLOCKS['dynamic_2']['slug'], DYNAMIC_BLOCKS['dynamic_2']['title']),
        build_dynamic_block_schema(DYNAMIC_BLOCKS['dynamic_3']['slug'], DYNAMIC_BLOCKS['dynamic_3']['title']),
      ],
    ],

    // MODULES
    [
      'key' => 'field_modules',
      'label' => 'Modules',
      'name' => 'modules',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Optional modules. These are pre-configured for specific use cases unlike `Custom Post Types`.',
      'layout' => 'block',
      'sub_fields' => array_merge(
        [
          generate_module_schema('blog', [
            [
              'key' => 'field_acc_terms_start',
              'label' => 'Custom Post Terms',
              'type' => 'accordion',
              'open' => 0,
            ],
            [
              'key' => 'field_acc_terms_message',
              'label' => 'CAUTION',
              'type' => 'message',
              'message' =>
                'Understand the consequences before changing post terms. Exsisting posts will be deleted and permalink structure will need to be re-saved.',
              'esc_html' => 1,
              'wrapper' => ['class' => 'warning'],
            ],
            [
              'key' => 'field_title',
              'label' => 'Title',
              'name' => 'title',
              'type' => 'text',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            ],
            [
              'key' => 'field_slug',
              'label' => 'Slug',
              'name' => 'slug',
              'type' => 'text',
              'instructions' => ACF_INSTRUCTIONS['CPT_SLUG'],
              'maxlength' => ACF_CONSTANTS['CPT_SLUG_MAX_LENGTH'],
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            ],
            [
              'key' => 'field_acc_terms_end',
              'label' => 'Custom Post Terms',
              'type' => 'accordion',
              'endpoint' => 1,
            ],
            [
              'key' => 'field_acc_appearance_start',
              'label' => 'Appearance',
              'type' => 'accordion',
              'open' => 0,
            ],
            [
              'key' => 'field_var_type',
              'label' => 'Variant',
              'name' => 'var_type',
              'type' => 'select',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'choices' => [
                0 => 'Default',
                1 => 'BLOX',
              ],
              'default_value' => 0,
            ],
            [
              'key' => 'field_var_show_author',
              'label' => 'Display Author',
              'name' => 'var_show_author',
              'type' => 'true_false',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'ui' => 1,
            ],
            [
              'key' => 'field_var_show_toc',
              'label' => 'Display TOC',
              'name' => 'var_show_toc',
              'type' => 'true_false',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
              'ui' => 1,
            ],
            [
              'key' => 'field_acc_appearance_end',
              'label' => 'Appearance',
              'type' => 'accordion',
              'endpoint' => 1,
            ],
          ]),
        ],
        [generate_module_schema('testimonial')],
        [generate_module_schema('faq')],
        [generate_module_schema('pricing-plan')],
        [generate_module_schema('partners', [], 'Coming soon')],
        [generate_module_schema('press', [], 'Coming soon')],
        [generate_module_schema('team')],

        // PREMIUM MODULES
        [generate_module_schema('concierge', [], 'Coming soon')],
        [generate_module_schema('calendar', [], 'Beta')],
        [generate_module_schema('partner', [], 'Beta')]
      ),
    ],

    // POPUP MODAL
    [
      'key' => 'field_theme-options_settings_popup',
      'label' => 'Popup Modal',
      'name' => 'popup_settings',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'sub_fields' => [
        [
          'key' => "field_popup_control",
          'label' => 'Activate',
          'name' => "popup_control",
          'type' => 'true_false',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'ui' => 1,
          'ui_on_text' => 'Enabled',
          'ui_off_text' => 'Disabled',
          'wrapper' => ['width' => '20'],
        ],
      ],
    ],

    // TOOLBAR
    [
      'key' => 'field_theme-options_settings_toolbar',
      'label' => 'Toolbar Apps',
      'name' => 'toolbar',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'sub_fields' => [
        [
          'key' => 'field_theme-options_settings_toolbar_dev',
          'label' => 'Dev Settings',
          'name' => 'dev',
          'type' => 'true_false',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'ui' => 1,
        ],
      ],
    ],
  ],

  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-settings",
      ],
    ],
  ],

  /* (int) Field groups are shown in order from lowest to highest. Defaults to 0 */
  'menu_order' => 0,
  /* (string) Determines the position on the edit screen. Defaults to normal. Choices of 'acf_after_title', 'normal' or 'side' */
  'position' => 'normal',
  /* (string) Determines the metabox style. Defaults to 'default'. Choices of 'default' or 'seamless' */
  'style' => 'seamless',
  /* (string) Determines where field labels are places in relation to fields.
   * Default: 'top'
   * Choices: 'top' (Above fields) | 'left' (Beside fields)
   */
  'label_placement' => 'top',
  /* (string) Determines where field instructions are places in relation to fields.
   * Default: 'label'
   * Choices: 'label' (Below labels) | 'field' (Below fields)
   */
  'instruction_placement' => 'label',
  /* (array) An array of elements to hide on the screen */
  'hide_on_screen' => '',
  /* (bool) Enable/Disable field group */
  'active' => true,
  /* (int) Expose custom field group to REST API */
  'show_in_rest' => 1,
  /* (string) Determines multilingual setup
   * Choices: `translation` (Same fields across languages) | `localization` (Different fields across languages) | `advanced` (Expert)
   */
  'acfml_field_group_mode' => 'translation',
]);

function generate_module_schema($module_key, $module_settings = [], $module_instructions = '') {
  if (!isset(MODULES[$module_key])) {
    return null;
  }

  $module = MODULES[$module_key];

  $schema = [
    'key' => 'field_group_' . $module['key'],
    'label' => $module['title'],
    'name' => $module['key'],
    'type' => 'group',

    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'instructions' => $module_instructions,
    'layout' => 'table',
    'sub_fields' => [
      [
        'key' => 'field_group_' . $module['key'] . '_control',
        'label' => 'Activate',
        'name' => $module['acf_control'],
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'ui_on_text' => 'Enabled',
        'ui_off_text' => 'Disabled',
        'wrapper' => ['width' => '20'],
      ],
    ],
  ];

  if (!empty($module_settings)) {
    $schema['sub_fields'][] = [
      'key' => 'field_' . $module['key'] . '_settings',
      'label' => 'Settings',
      'name' => 'settings',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'sub_fields' => $module_settings,
    ];
  }

  return $schema;
}

/**
 * Build Dynamic blocks schema
 */
function build_dynamic_block_schema(string $slug, string $title, array $custom = []): array {
  $schema = [
    'key' => "field_group_{$slug}",
    'label' => $title,
    'name' => $slug,
    'type' => 'group',
    'layout' => 'table',
    'sub_fields' => [
      /**
       * Control
       */
      [
        'key' => "field_{$slug}_control",
        'label' => 'Activate',
        'name' => "{$slug}_control",
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'ui_on_text' => 'Enabled',
        'ui_off_text' => 'Disabled',
        'wrapper' => ['width' => '20'],
      ],
      /**
       * Settings
       */
      [
        'key' => "field_{$slug}_settings",
        'label' => 'Settings',
        'name' => "{$slug}_settings",
        'type' => 'group',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'layout' => 'block',
        'sub_fields' => array_merge(
          // custom post terms
          [
            [
              'key' => "field_acc_{$slug}_settings_start",
              'label' => 'Custom Post Terms',
              'type' => 'accordion',
              'open' => 0,
            ],
          ],
          get_cpt_fields($slug),
          [
            [
              'key' => "field_acc_{$slug}_settings_end",
              'label' => 'Custom Post Terms',
              'type' => 'accordion',
              'endpoint' => 1,
            ],
          ],

          // appearance
          [
            [
              'key' => "field_acc_{$slug}_appearance_start",
              'label' => 'Appearance',
              'type' => 'accordion',
              'open' => 0,
            ],
          ],
          $custom,
          [
            [
              'key' => "field_acc_{$slug}_appearance_end",
              'label' => 'Appearance',
              'type' => 'accordion',
              'endpoint' => 1,
            ],
          ]
        ),
      ],
    ],
  ];

  return $schema;
}
