<?php

$settings = get_theme_options_config();

acf_add_options_page([
  'page_title' => 'Theme',
  'menu_slug' => "{$settings['slug']}-theme",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'edit_posts', // editor access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);

acf_add_local_field_group([
  'key' => 'group_theme-options_theme',
  'title' => "{$settings['title']} > Theme",
  'fields' => [
    // LOOK AND FEEL
    [
      'key' => 'field_group_multipliers',
      'label' => 'Appearance',
      'name' => 'appearance_multipliers',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Currently experimental, use with caution.',
      'layout' => 'table',
      'sub_fields' => [
        [
          'key' => 'field_multiplier_radius',
          'label' => 'Border Radius',
          'name' => 'radius',
          'type' => 'range',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'step' => '0.25',
          'min' => '0',
          'max' => '4',
          'default_value' => '1',
          'append' => '',
        ],
        [
          'key' => 'field_multiplier_space',
          'label' => 'Spacing',
          'name' => 'space',
          'type' => 'range',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'step' => '0.25',
          'min' => '0',
          'max' => '4',
          'default_value' => '1',
          'append' => '',
        ],
        [
          'key' => 'field_multiplier_text',
          'label' => 'Text',
          'name' => 'text',
          'type' => 'range',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'step' => '0.25',
          'min' => '0',
          'max' => '4',
          'default_value' => '1',
          'append' => '',
        ],
      ],
    ],

    // DEFAULT THEME
    [
      'key' => 'field_default_theme',
      'label' => 'Default Theme',
      'name' => 'default_theme',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'allow_in_bindings' => 1,
      'choices' => [
        1 => 'Light',
        2 => 'Dark',
        3 => 'System (Coming Soon)',
      ],
    ],

    // THEME PALETTE
    [
      'key' => 'field_group_palette',
      'label' => 'Themes',
      'name' => 'theme',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'table',
      'sub_fields' => [
        [
          'key' => 'field_group_palette_light',
          'label' => 'Light',
          'name' => 'light',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'layout' => 'row',
          'sub_fields' => theme_palette('light'),
        ],
        [
          'key' => 'field_group_palette_dark',
          'label' => 'Dark',
          'name' => 'dark',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'layout' => 'row',
          'sub_fields' => theme_palette('dark'),
        ],
      ],
    ],

    // TYPOGRAPHY
    [
      'key' => 'field_group_typography',
      'label' => 'Typography',
      'name' => 'typography',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'sub_fields' => array_merge(
        // fonts
        [
          [
            'key' => 'field_acc_fonts_start',
            'label' => 'Fonts',
            'type' => 'accordion',
            'open' => 0,
          ],
          [
            'key' => 'field_group_fonts',
            'name' => 'fonts',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => custom_font_fields(),
          ],
          [
            'key' => 'field_acc_fonts_end',
            'label' => 'Fonts',
            'type' => 'accordion',
            'endpoint' => 1,
          ],
        ],

        // font weights
        [
          [
            'key' => 'field_acc_font_weights_start',
            'label' => 'Font Weights',
            'type' => 'accordion',
            'open' => 0,
          ],
          [
            'key' => 'field_group_font_weights',
            'name' => 'font_weights',
            'type' => 'group',
            'layout' => 'row',
            'sub_fields' => font_weight_fields(),
          ],
          [
            'key' => 'field_acc_font_weights_end',
            'label' => 'Font Weights',
            'type' => 'accordion',
            'endpoint' => 1,
          ],
        ],
      ),
    ],
  ],

  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-theme",
      ],
    ],
  ],

  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'translation',
]);

function theme_palette(string $key = ''): array {
  return [
    // main
    [
      'key' => "field_theme_{$key}_primary",
      'label' => 'Primary',
      'name' => 'primary',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_secondary",
      'label' => 'Secondary',
      'name' => 'secondary',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_accent",
      'label' => 'Accent',
      'name' => 'accent',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_text",
      'label' => 'Text',
      'name' => 'text',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_text_muted",
      'label' => 'Text Muted',
      'name' => 'text_muted',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_background",
      'label' => 'Background',
      'name' => 'background',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_border",
      'label' => 'Border',
      'name' => 'border',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_caption",
      'label' => 'Caption',
      'name' => 'caption',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_link",
      'label' => 'Link',
      'name' => 'link',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    // greyscale
    [
      'key' => "field_theme_{$key}_acc_greyscale_start",
      'label' => 'Greyscale',
      'type' => 'accordion',
      'open' => 0,
    ],
    [
      'key' => "field_theme_{$key}_white",
      'label' => 'White',
      'name' => 'white',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'default_value' => '#ffffff',
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_black",
      'label' => 'Black',
      'name' => 'black',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'default_value' => '#000000',
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_1",
      'label' => 'Grey 1',
      'name' => 'grey_1',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_2",
      'label' => 'Grey 2',
      'name' => 'grey_2',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_3",
      'label' => 'Grey 3',
      'name' => 'grey_3',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_4",
      'label' => 'Grey 4',
      'name' => 'grey_4',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_5",
      'label' => 'Grey 5',
      'name' => 'grey_5',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_6",
      'label' => 'Grey 6',
      'name' => 'grey_6',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_7",
      'label' => 'Grey 7',
      'name' => 'grey_7',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_grey_8",
      'label' => 'Grey 8',
      'name' => 'grey_8',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_acc_greyscale_end",
      'label' => 'Greyscale',
      'type' => 'accordion',
      'endpoint' => 1,
    ],
    // elevation
    [
      'key' => "field_theme_{$key}_acc_elevation_start",
      'label' => 'Elevation',
      'type' => 'accordion',
      'open' => 0,
    ],
    [
      'key' => "field_theme_{$key}_level_1",
      'label' => 'Level 1',
      'name' => 'level_1',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_level_2",
      'label' => 'Level 2',
      'name' => 'level_2',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_level_3",
      'label' => 'Level 3',
      'name' => 'level_3',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_acc_elevation_end",
      'label' => 'Elevation',
      'type' => 'accordion',
      'endpoint' => 1,
    ],
    // signals
    [
      'key' => "field_theme_{$key}_acc_signals_start",
      'label' => 'Signals',
      'type' => 'accordion',
      'open' => 0,
    ],
    [
      'key' => "field_theme_{$key}_success",
      'label' => 'Success',
      'name' => 'success',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_warning",
      'label' => 'Warning',
      'name' => 'warning',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_error",
      'label' => 'Error',
      'name' => 'error',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
    ],
    [
      'key' => "field_theme_{$key}_acc_signals_end",
      'label' => 'Signals',
      'type' => 'accordion',
      'endpoint' => 1,
    ],
  ];
}

function custom_font_fields(): array {
  return [
    [
      'key' => 'field_group_fonts_control',
      'label' => 'Settings',
      'name' => 'control',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'sub_fields' => [
        [
          'key' => 'field_font_enable',
          'label' => 'Custom Fonts',
          'name' => 'enable',
          'type' => 'true_false',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'ui' => 1,
          'wrapper' => ['width' => '20'],
        ],
        [
          'key' => 'field_font_provider',
          'label' => 'Font Provider',
          'name' => 'provider',
          'type' => 'select',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'choices' => [
            1 => 'Google Fonts',
            2 => 'Local (Coming Soon)',
          ],
          'default_value' => 0,
          'required' => 1,
          'conditional_logic' => [
            [
              [
                'field' => 'enable_custom_font',
                'operator' => '==',
                'value' => '1',
              ],
            ],
          ],
          'wrapper' => ['width' => '80', 'class' => 'acf-view-cond'],
        ],
      ],
    ],
    [
      'key' => 'field_group_fonts_custom',
      'label' => 'Custom Fonts',
      'name' => 'custom',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'table',
      'sub_fields' => [
        [
          'key' => 'field_group_fonts_custom_primary',
          'label' => 'Primary',
          'name' => 'primary',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'instructions' => 'Used for Heading text',
          'layout' => 'block',
          'sub_fields' => [
            [
              'key' => 'field_fonts_custom_primary_name',
              'label' => 'Font Family Name',
              'name' => 'name',
              'type' => 'text',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            ],
            [
              'key' => 'field_fonts_custom_primary_link',
              'label' => 'Font Family Link',
              'name' => 'link',
              'type' => 'text',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            ],
          ],
        ],
        [
          'key' => 'field_group_fonts_custom_secondary',
          'label' => 'Secondary',
          'name' => 'secondary',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'instructions' => 'Used for Body text',
          'layout' => 'block',
          'sub_fields' => [
            [
              'key' => 'field_fonts_custom_primary_name',
              'label' => 'Font Family Name',
              'name' => 'name',
              'type' => 'text',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            ],
            [
              'key' => 'field_fonts_custom_primary_link',
              'label' => 'Font Family Link',
              'name' => 'link',
              'type' => 'text',
              'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            ],
          ],
        ],
      ],
    ],
  ];
}

function font_weight_fields(): array {
  $font_weights = [
    ['name' => 'light', 'value' => 300, 'label' => 'Light (300)', 'field_label' => 'Font Weight Light'],
    ['name' => 'normal', 'value' => 400, 'label' => 'Normal (400)', 'field_label' => 'Font Weight Normal'],
    ['name' => 'medium', 'value' => 500, 'label' => 'Medium (500)', 'field_label' => 'Font Weight Medium'],
    ['name' => 'semibold', 'value' => 600, 'label' => 'Semibold (600)', 'field_label' => 'Font Weight Semibold'],
    ['name' => 'bold', 'value' => 700, 'label' => 'Bold (700)', 'field_label' => 'Font Weight Bold'],
  ];

  $choices = [];
  foreach ($font_weights as $weight) {
    $choices[$weight['value']] = $weight['label'];
  }

  $fields = [];
  foreach ($font_weights as $weight) {
    $fields[] = [
      'key' => "field_font_weight_{$weight['name']}",
      'label' => $weight['field_label'],
      'name' => $weight['name'],
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'choices' => $choices,
      'default_value' => $weight['value'],
    ];
  }

  return $fields;
}
