<?php

/**
 * register and load all fields + option pages via php
 *
 * @link https://www.advancedcustomfields.com/resources/register-fields-via-php/#field-type-settings
 */

include_once get_stylesheet_directory() . '/lib/acf/schemas/helpers.php';

function preload_schemas() {
  if (!function_exists('acf_add_local_field_group') || !function_exists('acf_add_options_page')) {
    return;
  }
  $common = glob(__DIR__ . '/common/*.php');
  foreach ($common as $file) {
    include_once $file;
  }

  $options_pages = glob(__DIR__ . '/options-pages/*.php');
  foreach ($options_pages as $file) {
    include_once $file;
  }
}

function load_schemas() {
  if (!function_exists('acf_add_local_field_group')) {
    return;
  }

  $field_groups = glob(__DIR__ . '/field-groups/*.php');
  foreach ($field_groups as $file) {
    include_once $file;
  }

  $block_field_groups = glob(__DIR__ . '/field-groups/blocks/*.php');
  foreach ($block_field_groups as $file) {
    include_once $file;
  }
}
