<?php
/**
 * Template Name: Blog Archive
 * PLX Scope: 23
 */
?>

<?php get_header(); ?>

<?php
$modules = get_theme_option('modules');
$blog_settings = $modules['blog']['settings'];
$post_type_slug = !empty($blog_settings['slug']) ? $blog_settings['slug'] : MODULES['blog']['slug'];
$terms = get_terms([
  'taxonomy' => 'blog_categories',
  'hide_empty' => true,
]);
// $show_author = $blog_settings['var_show_author'];
$show_author = false; // disable until `$processed` is more stable

$query_args = [
  'post_type' => $post_type_slug,
  'posts_per_page' => 12,
  'paged' => 1,
  'post_status' => 'publish',
  'orderby' => 'date',
  'order' => 'DESC',
];
$posts_query = new WP_Query($query_args);

$page_title = esc_html(post_type_archive_title('', false));

$type = match ($modules['blog']['settings']['var_type'] ?? null) {
  '1' => 'variant--blox',
  default => null,
};

$max_pages = $posts_query->max_num_pages;
$ajax_id = 'blog_pagination_' . uniqid();
$base_comp_args = [
  'type' => $type,
  'show_author' => false,
];
?>

<section
  data-plx="23"
  class="<?= cn('section', 'archive', $type) ?>"
>
  <div class="layout-block">
    <div class="layout-row" data-gap="sm">
      <div class="layout_column">
        <div class="column">
          <?php component('copy', [
            'type' => 'variant--section',
            'has_title' => !empty($page_title),
            'title' => $page_title,
          ]); ?>
        </div>
        <div class="column">
          <?php if (is_array($terms) && !empty($terms)):
            component('terms', [
              'className' => '',
              'target' => 'filter.termFilter',
              'ajax' => [
                'action' => 'filter_posts_by_term',
                'callback' => 'blog_loader',
                'container' => $ajax_id,
                'query_args' => $query_args,
              ],
              'options' => [
                'max_pages' => $max_pages,
              ],
              'terms' => $terms,
            ]);
          endif; ?>
        </div>
      </div>

      <?php if ($posts_query->have_posts()): ?>
        <div class="blog-layout <?= esc_attr($ajax_id) ?>" id="<?= esc_attr($ajax_id) ?>">
          <?php while ($posts_query->have_posts()):
            $posts_query->the_post();
            $args = array_merge($base_comp_args, [
              'title' => get_the_title(),
              'link' => get_the_permalink(),
              'date' => get_localized_date(),
              'feat_image' => get_feat_img(),
              'author_image' => get_field('user_image', 'user_' . get_post_field('post_author')),
              'author_name' => get_author_full_name(),
            ]);
            component('blog/blog-card', $args);
          endwhile; ?>
        </div>

        <?php if ($max_pages > 1): ?>
          <?php component('pagination', [
            'type' => 'load-more',
            'ajax' => [
              'callback' => 'blog_loader',
              'container' => $ajax_id,
              'query_args' => $query_args,
              'component_args' => $base_comp_args,
            ],
            'options' => [
              'per_page' => 12,
              'max_pages' => $max_pages,
            ],
          ]); ?>
        <?php endif; ?>


      <?php else: ?>
        <?php component('error-boundary', [
          'title' => 'No Posts Found',
          'details' => 'Add posts, or remove this block.',
        ]); ?>
      <?php endif; ?>
      <?php wp_reset_postdata(); ?>

    </div>
  </div>
</section>

<?php get_footer(); ?>
