<?php
/**
 * Template Name: Blog Single
 * PLX Scope: 23
 */
?>

<?php
$modules = get_theme_option('modules');
$blog_settings = $modules['blog']['settings'];
$type = match ($blog_settings['var_type'] ?? null) {
  '1' => 'variant--blox',
  default => null,
};

$archive_link = get_post_type_archive_link(get_post_type());
$archive_name = get_post_type_object(get_post_type())->labels->name;

// $show_author = $blog_settings['var_show_author'];
$show_author = false; // disable until `$processed` is more stable
$author_image = get_field('user_image', 'user_' . get_post_field('post_author')) ?: [];
$author_name = get_author_full_name();

$title = get_the_title();
$content = get_field('content');
$date = get_localized_date();

$author_id = get_post_field('post_author');
$author = get_userdata($author_id);

// $show_toc = $blog_settings['var_show_toc'];
$show_toc = false; // disable until `$processed` is more stable

$feat_image = get_feat_img();

// expiremental
$processed = generate_table_of_contents($content);
?>

<?php get_header(); ?>

<section
  data-plx="23"
  class="<?= cn('section', 'single', $type) ?>"
>

  <div class="layout-block">
    <div class="layout-article">

      <div class="hero">

        <div class="hero-category">
          <a href="<?= esc_url($archive_link) ?>" class="link">
            <?= get_icon('chevron-left') ?>
            <?= esc_html($archive_name) ?>
          </a>
        </div>

        <div class="hero-title">
          <div class="copy variant--section variant--subsection align--center">
            <div class="copy--header">
              <div class="copy--title"><h1><?= esc_html($title) ?></h1></div>
            </div>
          </div>
        </div>

        <?php if ($show_author): ?>
          <div class="hero-author">
            <div class="author">
              <?php if (!empty($author_image)): ?>
              <div class="author-avatar">
                <img src="<?= esc_url($author_image['url']) ?>" />
              </div>
              <?php endif; ?>
              <div class="author-info">
                <h3><?= esc_html($author_name) ?></h3>
              </div>
            </div>
          </div>
        <?php endif; ?>

      </div>

      <article class="content">
        <div class="layout-row align--center">


          <div class="content-meta">
            <div class="time-to-read">
              <?= get_reading_time($content) ?>
            </div>
            <div class="article-date">
              <?= $date ?>
            </div>
          </div>

          <?php if (!empty($feat_image)): ?>
            <div class="content-banner">
              <?php if ($feat_image['url']): ?>
                <div class="figure">
                  <div class="figure_inner">
                    <?= $feat_image['full_tag'] ?>
                  </div>
                </div>
              <?php endif; ?>
            </div>
          <?php endif; ?>

          <?php if ($show_toc): ?>
            <div class="content-toc">
              <h2>
                <?php _e('Table of Contents', 'plexible-theme-modules_blog'); ?>
              </h2>
              <?= $processed['toc'] ?>
            </div>
          <?php endif; ?>

          <div class="content-content">
            <div class="copy">
              <div class="copy--body">
                <div class="wysiwyg"><?= $content ?></div>
              </div>
            </div>
          </div>

        </div>
      </article>

    </div>
  </div>

  <?php component('block-builder'); ?>

</section>

<?php get_footer(); ?>
