<?php

/**
 * Template Name: CPT 2 Single Template
 *
 * Single post page for PLX 3
 */

$post_type_slug = get_theme_option('custom_post_type_2_slug');
$post_type_title = get_theme_option('custom_post_type_2_title');
$has_title = get_field('has_title');
$has_nav = get_field('has_nav');
$page_title = get_the_title();
$archive_link = get_post_type_archive_link($post_type_slug);

$description = get_field('description');
$gallery = get_field('gallery');
$year = get_field('year');
$info_title = get_field('info_title');
$terms = get_the_terms(get_the_id(), 'custom_post_type_2_category');
$has_info_table = get_field('has_info_table');
$info_table = get_field('info_table');
$has_message = get_field('has_message');
$message = get_field('message');
?>

<?php get_header(); ?>

<div
  data-plx="3"
  class="single"
>
  <?php if (empty($has_title)): ?>
    <h1 class="sr-only"><?= esc_html($page_title) ?></h1>
  <?php endif; ?>

  <?php if (!empty($has_title) || !empty($has_nav)): ?>
    <div class="single-head">
      <div class="single-head_layout">
        <div class="stack">
          <?php if ($has_nav): ?>
            <a href="<?= esc_url($archive_link) ?>" class="nav-link link">
              <?= get_icon('chevron-left') ?>
              <?php _e('Back to', 'plexible-theme-terms_controls'); ?> <?= esc_html($post_type_title) ?>
            </a>
          <?php endif; ?>
          <?php if ($has_title): ?>
            <div class="copy variant--hero">
              <div class="copy--header">
                <h1 class="copy--title"><?= $page_title ?></h1>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php if ($has_message): ?>
    <?php if ($message): ?>
      <div class="c3-single-message">
        <div class="message">
          <?php if ($message['type'] === 'link'): ?>
            <a href="<?= $message['link']['url'] ?>" class="link">
              <?= get_icon('info') ?>
              <?= $message['link']['title'] ?>
              <?= get_icon('chevron-right') ?>
            </a>
          <?php endif; ?>
          <?php if ($message['type'] === 'text'): ?>
            <span class="text">
              <?= get_icon('info') ?>
              <?= $message['text'] ?>
            </span>
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>
  <?php endif; ?>

  <?php if ($has_info_table || $gallery): ?>
      <section class="section">
        <div class="layout-block">
          <div class="layout-row">

            <?php if ($gallery): ?>
              <div class="swiper" data-js-target="swiper.c3Slider">
                <div class="swiper-wrapper">
                  <?php foreach ($gallery as $image): ?>
                    <div class="swiper-slide">
                      <div class="figure">
                        <img
                          src="<?= esc_url($image['url']) ?>"
                          alt="<?= esc_attr($image['alt']) ?>"
                        />
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>

              <div class="controls variant--space-between" data-js-target="swiper.c3SliderControls">
                <div class="swiper-navigation">
                  <button class="icon-button variant--secondary --prev">
                    <span class="sr-only">Previous</span>
                    <?= get_icon('chevron-left') ?>
                  </button>
                  <button class="icon-button variant--secondary --next">
                    <span class="sr-only">Next</span>
                    <?= get_icon('chevron-right') ?>
                  </button>
                </div>
                <div class="swiper-progress">
                  <div class="swiper-progress-index-first"></div>
                  <div class="swiper-progress-bar"></div>
                  <div class="swiper-progress-index-last"></div>
                </div>
              </div>
            <?php endif; ?>

            <?php if ($has_info_table): ?>
              <?php if ($info_table): ?>
                <?php if ($info_table['title']): ?>
                  <div class="copy variant--section">
                    <h3 class="copy--title"><?= $info_table['title'] ?></h3>
                  </div>
                <?php endif; ?>

                <div class="c3-single-details">
                  <div class="layout-column" data-columns="2,1,1,1">
                    <?php if ($info_table['description']): ?>
                      <div class="copy variant--detail">
                        <div class="copy--header">
                          <span class="copy--caption">Description</span>
                        </div>
                        <div class="copy--body">
                          <div><?= $info_table['description'] ?></div>
                        </div>
                      </div>
                    <?php endif; ?>
                    <div class="copy variant--detail">
                      <div class="copy--header">
                        <span class="copy--caption"><?php _e('Type', 'shooga-cubes-terms'); ?></span>
                      </div>
                      <div class="copy--body">
                        <?php if (is_array($terms)): ?>
                          <ul>
                            <?php foreach ($terms as $term): ?>
                              <li><?= $term->name ?></li>
                            <?php endforeach; ?>
                          </ul>
                        <?php endif; ?>
                      </div>
                    </div>
                    <?php if ($info_table['client']): ?>
                      <div class="copy variant--detail">
                        <div class="copy--header">
                          <span class="copy--caption">Client</span>
                        </div>
                        <div class="copy--body">
                          <div><?= $info_table['client'] ?></div>
                        </div>
                      </div>
                    <?php endif; ?>
                    <?php if ($info_table['year']): ?>
                      <div class="copy variant--detail">
                        <div class="copy--header">
                          <span class="copy--caption">Year</span>
                        </div>
                        <div class="copy--body">
                          <div><?= $info_table['year'] ?></div>
                        </div>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>
              <?php endif; ?>
            <?php endif; ?>

          </div>
        </div>
      </section>
  <?php endif; ?>

  <?php component('block-builder'); ?>
</div>

<?php get_footer(); ?>
