# Plexible Theme

Locked, Loaded and Ready to Launch.

For a detailed list of changes view the [changelog](changelog.md).

## Quick setup

1. Install dependencies:

   ```sh
   pnpm install
   ```

2. Setup environment variables: (see .env.example)

3. Start development server:

   ```sh
   pnpm dev
   ```

4. Build for production

   ```sh
   pnpm build
   ```

## Project structure

```
├── admin/                        # CMS only functions and customization
├── assets/                       # Static assets
├── blocks/                       # Gutenberg blocks
├── components/                   # Reusable UI components
│   ├── classic/                  # Components for classic (legacy) editor
│   ├── ui/                       # Components for gutenberg editor
│   └── ...                       # Other components
├── data/                         # Global data objects and helpers
├── functions/                    # Reusable application functions
├── layouts/                      # Twig layouts
├── lib/                          # Utility libraries and functions
│   ├── acf/                      # ACF schemas and utilities
│   └── ...                       # Other libraries
├── page-templates/               # WordPress templates
│   ├── builder.php               # Entry point for Classic Editor
│   ├── gutenberg-builder.php     # Entry point for Gutenberg Editor
│   └── ...                       # Other templates
├── scripts/                      # JS scripts
│   ├── app.js                    # Main application entry point
│   └── ...                       # Other JS modules
└── styles/                       # CSS styling system
```

## Available scripts

- `pnpm dev` — Start Vite development server
- `pnpm build` — Build the project for production
- `pnpm version-sync` — Update the version number throughout the project

## Git workflow (WIP)

This repo loosely follows [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/#specification) for commit messages.

## Release workflow

1. Bump version

- Update package version in `package.json`

  ```sh
  pnpm version patch # or minor or major
  ```

- Run the sync script

  ```sh
  pnpm run version-sync
  ```
