import Alpine from 'alpinejs';
import { persist } from '@alpinejs/persist';

Alpine.plugin(persist);
Alpine.prefix('data-x-');
window.Alpine = Alpine;

document.addEventListener('alpine:init', () => {
  Alpine.store('devSettings', {
    gridOverlay: Alpine.$persist(false).as('dev:gridOverlay'),
    blockInspector: Alpine.$persist(false).as('dev:blockInspector'),
  });
  Alpine.store('mobileMenu', {
    isOpen: Alpine.$persist(false).as('menu:isOpen'),
    toggle() {
      this.isOpen = !this.isOpen;
    },
  });
  Alpine.data('themeEditor', () => ({
    isOpen: false,
    isLoading: false,
    message: '',
    isError: false,
  }));
});

Alpine.start();
