async function fetchPosts(params = {}) {
  try {
    const response = await fetch(fetch_object.fetchurl, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
      body: new URLSearchParams(params),
    });

    const isJson = response.headers
      .get('content-type')
      ?.includes('application/json');

    return isJson ? await response.json() : await response.text();
  } catch (error) {
    console.error('Fetch error:', error);
    return null;
  }
}
