const onWindowResize = () => {
  const htmlNode = document.documentElement;
  htmlNode.style.setProperty('--vh', `${window.innerHeight * 0.01}px`);
  htmlNode.style.setProperty('--document-width', `${window.innerWidth}px`);
};

function debounce(func, wait = 100) {
  let timeout;
  return () => {
    clearTimeout(timeout);
    timeout = setTimeout(func, wait);
  };
}

const debouncedResize = debounce(onWindowResize);

window.addEventListener('resize', debouncedResize);

export const init = onWindowResize;
