import { gsap } from 'gsap';
import { SplitText } from 'gsap/SplitText';

export class CharacterRevealHorizontalEffect {
  constructor(textElement) {
    if (!textElement || !(textElement instanceof HTMLElement)) {
      throw new Error('Invalid text element provided to BlurScrollEffect');
    }

    this.textElement = textElement;
    this.initializeEffect();
  }

  initializeEffect() {
    // listen for resize to rebuild
    window.addEventListener('resize', this.refresh);

    // split the text into words and chars using GSAP SplitText
    this.splitter = new SplitText(this.textElement, {
      type: 'words,chars',
    });

    // run the animation
    this.reveal();
  }

  reveal() {
    const chars = this.splitter.chars;

    this.tween = gsap.fromTo(
      chars,
      {
        opacity: 0,
        x: '50%',
      },
      {
        opacity: 1,
        x: '0',
        stagger: 0.05,
        ease: 'none',
        scrollTrigger: {
          trigger: this.textElement,
          start: 'top bottom-=50%',
          scrub: false,
        },
      }
    );
  }

  kill() {
    if (this.tween) {
      this.tween.scrollTrigger.kill();
      this.tween.kill();
      this.tween = null;
    }
    if (this.splitter) {
      this.splitter.revert();
    }
  }

  refresh() {
    this.kill();
    this.initializeEffect();
  }
}
