import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';
import { SplitText } from 'gsap/SplitText';
import { Observer } from 'gsap/Observer';
import { CustomEase } from 'gsap/CustomEase';

import { BlurScrollEffect } from './blur-scroll';
import { SplitLinesScrollEffect } from './split-lines';
import { FadeInEffect } from './fade-in';
import { CharacterRevealHorizontalEffect } from './character-reveal';

gsap.registerPlugin(ScrollTrigger, SplitText, CustomEase, Observer);

const init = () => {
  const effects = [
    { selector: '[data-motion="blur-scroll"]', effect: BlurScrollEffect },
    { selector: '[data-motion="split-lines"]', effect: SplitLinesScrollEffect },
    { selector: '[data-motion="fade-in"]', effect: FadeInEffect },
    {
      selector: '[data-motion="character-reveal-x"]',
      effect: CharacterRevealHorizontalEffect,
    },
  ];

  effects.forEach(({ selector, effect }) => {
    document.querySelectorAll(selector).forEach((el) => {
      new effect(el);
    });
  });
};

init();
