import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';
import Lenis from 'lenis';
import { $body } from '../utils/dom';

export const lenis = new Lenis({
  lerp: 0.1,
  anchors: true,
});

export function lockScroll() {
  lenis.stop();
  $body.style.overflow = 'hidden';
}

export function unlockScroll() {
  lenis.start();
  $body.style.overflow = '';
}

function initializeSmoothScroll() {
  // sync ScrollTrigger with Lenis' scroll updates
  lenis.on('scroll', ScrollTrigger.update);

  // ensure GSAP animations are in sync with Lenis' scroll frame updates
  gsap.ticker.add((time) => {
    lenis.raf(time * 1000); // convert GSAP's time to ms
  });

  // turn off GSAP's default lag smoothing to avoid conflicts
  gsap.ticker.lagSmoothing(0);
}

export const init = initializeSmoothScroll();
