import { lockScroll, unlockScroll } from '../motion/smoothscroll';

// gather all <dialog.c-dialog>
function collectDialogs() {
  return new Map([...document.querySelectorAll('dialog.c-dialog')].map((dlg) => [dlg.id, dlg]));
}

// handle open
function bindOpeners(dialogs) {
  document.querySelectorAll('[data-dialog-open]').forEach((el) => {
    el.addEventListener('click', () => {
      const dlg = dialogs.get(el.dataset.dialogOpen);
      if (!dlg) return;
      dlg.showModal?.();
      dlg.classList.add('is-active');
      lockScroll();
    });
  });
}

// handle close
function bindClosers(dialogs) {
  const CLOSE_SEL = '[data-dialog-close]';
  const INNER_SEL = '[data-dialog-inner]';

  dialogs.forEach((dlg) => {
    // explicit close buttons
    dlg
      .querySelectorAll(CLOSE_SEL)
      .forEach((el) => el.addEventListener('click', () => dlg.close()));
    // if the click target is NOT inside [data-dialog-inner], close
    dlg.addEventListener('click', (evt) => {
      if (!evt.target.closest(INNER_SEL)) dlg.close();
    });
    // cleanup
    dlg.addEventListener('close', () => {
      dlg.classList.remove('is-active');
      unlockScroll();
    });
  });
}

function initializeDialogs() {
  const dialogs = collectDialogs();
  if (!dialogs.size) return;
  bindOpeners(dialogs);
  bindClosers(dialogs);
}

export const init = initializeDialogs;
