import gsap from 'gsap';

const animateMarquee = () => {
  const marquee = document.querySelector('.marquee');
  const track = marquee?.querySelector('.marquee_track');
  if (!marquee || !track) return;

  gsap
    .timeline({
      defaults: {
        ease: 'none',
      },
      scrollTrigger: {
        trigger: marquee,
        start: 'clamp(top bottom)',
        end: 'bottom top',
        scrub: true,
      },
    })
    .to(
      track,
      {
        xPercent: -50,
      },
      0
    );
};

export const init = animateMarquee;
