const pageTransition = () => {
  const node = document.querySelector('.page-transition');
  if (!node) return;

  document.body.addEventListener('click', (e) => {
    const a = e.target.closest('a');
    if (!a) return;

    if (a.target === '_blank' || a.origin !== location.origin) return;

    const isHashOnly = a.getAttribute('href').startsWith('#');
    const isSamePageNav = a.hash && a.pathname === location.pathname;
    if (isHashOnly || isSamePageNav) return;

    e.preventDefault();
    node.classList.add('exit');

    node.addEventListener(
      'animationend',
      () => {
        location.href = a.href;
      },
      { once: true }
    );
  });
};

export const init = pageTransition;
