import { lenis } from '../motion/smoothscroll';
import { $html } from '../utils/dom';

const HEADER_SEL = document.querySelector('header.c-header');

function setScrollState() {
  const getHeaderHeight = () => {
    const documentStyles = getComputedStyle($html);
    const raw = documentStyles.getPropertyValue('--header-height').trim(); // e.g. "56px"
    const px = Number.parseFloat(raw);

    return Number.isFinite(px) ? px : HEADER ? HEADER.offsetHeight : 0;
  };

  const OFFSET = 50;
  let trigger = 0;
  let triggerDown = 0;
  let isScrolled = null;

  const recomputeThreshold = () => {
    const headerHeight = getHeaderHeight();
    trigger = OFFSET + headerHeight;
    triggerDown = Math.max(0, trigger - 4);
  };

  const applyState = (next) => {
    if (isScrolled !== next) {
      isScrolled = next;
      HEADER_SEL.classList.toggle('is-scrolled', next);
    }
  };

  const updateScrollState = (y) => {
    if (isScrolled === true) {
      if (y <= triggerDown) applyState(false);
    } else {
      applyState(y >= trigger);
    }
  };

  // initial compute and set
  recomputeThreshold();
  updateScrollState(lenis.scroll);

  // lenis driven updates
  const onLenisScroll = ({ scroll }) => updateScrollState(scroll);
  lenis.on('scroll', onLenisScroll);

  // viewport driven updates
  const onResize = () => {
    recomputeThreshold();
    updateScrollState(lenis.scroll);
  };
  window.addEventListener('resize', onResize, { passive: true });
}

// add `is-transparent` class on header if it's first child in builder
function setTransparentState() {
  const builder = document.querySelector('.builder_2-0');
  const isPlxOneFirstChild = builder?.firstElementChild?.dataset.plx === '1';

  HEADER_SEL.classList.toggle('is-transparent', isPlxOneFirstChild);
}

function initializeSiteHeader() {
  if (!HEADER_SEL) return;
  setScrollState();
  setTransparentState();
}

export const init = initializeSiteHeader;
