function collectWYSIWYG() {
  return [...document.querySelectorAll('.c-wysiwyg')];
}

function bindAttributes(elements) {
  elements.forEach((el) => {
    if (!el.children.length > 1) return;

    for (const child of el.children) {
      child.setAttribute('data-scroll', '');
      child.setAttribute('data-scroll-offset', '0%,50%');
      child.classList.add('motion-slide-in');
    }
  });
}

function initializeWYSIWYG() {
  const components = collectWYSIWYG();
  if (components.length === 0) return;

  bindAttributes(components);
}

export const init = initializeWYSIWYG;
