export const isObject = (x) => x && typeof x === 'object';
export const isFunction = (x) => typeof x === 'function';

/**
 * Determines if the browser is Safari
 * @return {boolean}
 */
export function isSafari() {
  // check if the userAgent contains "Safari" and "Version"
  if (navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Version') != -1) {
    return true;
  }
  return false;
}

/**
 * Determines if the device is a touch device
 * @return {boolean}
 */
export const isTouchDevice = () => {
  return 'ontouchstart' in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0;
};
