const fs = require('fs');
const packageJson = require('./package.json');
const version = packageJson.version;

// Update PHP version constant
const functionsPhp = './functions.php';
fs.readFile(functionsPhp, 'utf8', (err, data) => {
  if (err) return console.error('Error reading functions.php:', err);
  const updated = data.replace(
    /define\('THEME_VERSION',\s*'.*?'\);/,
    `define('THEME_VERSION', '${version}');`
  );
  fs.writeFile(functionsPhp, updated, 'utf8', (err) => {
    if (err) console.error('Error updating functions.php:', err);
  });
});

// Update style.css version
const styleCss = './style.css';
fs.readFile(styleCss, 'utf8', (err, data) => {
  if (err) return console.error('Error reading style.css:', err);
  const updated = data.replace(/^(Version:\s*)(.*)$/m, (_m, prefix) => `${prefix}${version}`);
  fs.writeFile(styleCss, updated, 'utf8', (err) => {
    if (err) console.error('Error updating style.css:', err);
  });
});
